/*---------------------------------------------*\
|  Color Nokia LCD Menu Library					|
| This library contains a menu system for the	|
| Nokia Color LCD.  It uses the Nokia Color LCD	|
| Text library (color_lcd_text.h) and Nokia		|
| Color LCD Interface library (color_lcd.h)		|
|												|
| Adam Honse (CalcProgrammer1) 5-10-2011		|
\*---------------------------------------------*/

#include "color_lcd_menu.h"

void color_lcd_print_menu_line(char * text, char textlength, int textcolor, int bgcolor, char linenumber)
{
	color_lcd_draw_rectangle(bgcolor, 0, (linenumber*10)+1, 131, ((linenumber+1)*10));
	color_lcd_print_string(text, textlength, textcolor, 2, (linenumber*10)+2);
}

char color_lcd_print_menu(char menu_text[][22], char menu_length, char starting_position, int title_color, int title_bgcolor, int entry_color, int entry_bgcolor, int highlight_color, int highlight_bgcolor)
{
	char selected_item = 1;

	DDRC &= 0b11111000;
	PORTC |= 0b00000111;

	//Print title line
	color_lcd_print_menu_line(menu_text[0], 21, title_color, title_bgcolor, 0);

	//Print menu lines
	for(char i = 1; i < 13; i++)
	{
		if(i <= menu_length)
		{
			color_lcd_print_menu_line(menu_text[i], 21, entry_color, entry_bgcolor, i);
		}
		else
		{
			//Print blank lines for unused entries
			color_lcd_print_menu_line(0, 0, entry_bgcolor, entry_bgcolor, i);
		}
	}

	//Make sure starting position is valid, if it is not, start at the first item
	if((starting_position <= menu_length) && (starting_position > 0))
	{
		selected_item = starting_position;
	}

	//Highlight selected item
	color_lcd_print_menu_line(menu_text[selected_item], 21, highlight_color, highlight_bgcolor, selected_item);

	//User Selection Loop
	while(1)
	{
		if(bit_is_clear(PINC, PC0))
		{
			if(selected_item < menu_length)
			{
				//Un-highlight currently highligted item
				color_lcd_print_menu_line(menu_text[selected_item], 21, entry_color, entry_bgcolor, selected_item);
	
				//Select next item
			   	selected_item++;

				//Highlight new selected item
				color_lcd_print_menu_line(menu_text[selected_item], 21, highlight_color, highlight_bgcolor, selected_item);
			}
		}

		else if(bit_is_clear(PINC, PC1))
		{
			if(selected_item > 1)
			{
				//Un-highlight currently highligted item
				color_lcd_print_menu_line(menu_text[selected_item], 21, entry_color, entry_bgcolor, selected_item);
	
				//Select previous item
			   	selected_item--;

				//Highlight new selected item
				color_lcd_print_menu_line(menu_text[selected_item], 21, highlight_color, highlight_bgcolor, selected_item);
			}
		}

		else if(bit_is_clear(PINC, PC2))
		{
			return selected_item;
		}
		_delay_ms(250);
	}
}
